/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.voxelutopia.ultramarine.data.registry.RecipeSerializerRegistry;
import com.voxelutopia.ultramarine.data.registry.RecipeTypeRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiselTableRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient material;
    protected final Ingredient template;
    protected final List<Ingredient> colors;
    protected final ItemStack result;

    public ChiselTableRecipe(ResourceLocation pId, String pGroup, Ingredient material, Ingredient template, Ingredient[] colors, ItemStack pResult) {
        this.id = pId;
        this.group = pGroup;
        this.material = material;
        this.template = template;
        this.colors = new ArrayList<Ingredient>();
        this.colors.addAll(Arrays.asList(colors));
        this.result = pResult;
    }

    public boolean m_5818_(Container pContainer, @NotNull Level pLevel) {
        ItemStack usedMaterial = pContainer.m_8020_(0);
        ItemStack usedTemplate = pContainer.m_8020_(1);
        List<Object> usedColors = Arrays.asList(ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_);
        int i = 0;
        for (int j = 2; j < pContainer.m_6643_(); ++j) {
            usedColors.set(i, pContainer.m_8020_(j));
            ++i;
        }
        usedColors = usedColors.stream().filter(item -> !item.m_41619_()).collect(Collectors.toList());
        return this.material.test(usedMaterial) && this.template.test(usedTemplate) && ChiselTableRecipe.compareColors(this.colors, usedColors);
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container pContainer, @NotNull RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public Ingredient getMaterial() {
        return this.material;
    }

    public Ingredient getTemplate() {
        return this.template;
    }

    public List<Ingredient> getColors() {
        return this.colors;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.CHISEL_TABLE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.CHISEL_TABLE.get();
    }

    private static boolean compareColors(List<Ingredient> recipeColors, List<ItemStack> usedColors) {
        if (recipeColors.size() != usedColors.size()) {
            return false;
        }
        ArrayList<ItemStack> usedColorsReverse = new ArrayList<ItemStack>(usedColors);
        Collections.reverse(usedColorsReverse);
        boolean fwd = true;
        boolean rvs = true;
        for (int i = 0; i < recipeColors.size(); ++i) {
            fwd = recipeColors.get(i).test(usedColors.get(i)) && fwd;
            rvs = recipeColors.get(i).test((ItemStack)usedColorsReverse.get(i)) && rvs;
        }
        return fwd || rvs;
    }

    public static class Serializer
    implements RecipeSerializer<ChiselTableRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("ultramarine", "chisel_table");

        protected Serializer() {
        }

        @NotNull
        public ChiselTableRecipe fromJson(@NotNull ResourceLocation pRecipeId, JsonObject pJson) {
            ItemStack result;
            if (!pJson.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            String group = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
            Ingredient material = Serializer.parseIngredient(pJson, "material");
            Ingredient template = Serializer.parseIngredient(pJson, "template");
            JsonArray colorsJson = GsonHelper.m_13933_((JsonObject)pJson, (String)"colors");
            Ingredient[] colors = new Ingredient[colorsJson.size()];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = Ingredient.m_43917_((JsonElement)colorsJson.get(i));
            }
            if (pJson.get("result").isJsonObject()) {
                result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
            } else {
                String s1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"result");
                ResourceLocation resourcelocation = new ResourceLocation(s1);
                result = new ItemStack((Holder)ForgeRegistries.ITEMS.getHolder(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
            }
            return new ChiselTableRecipe(pRecipeId, group, material, template, colors, result);
        }

        @Nullable
        public ChiselTableRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            String group = pBuffer.m_130277_();
            Ingredient material = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient template = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient[] colors = new Ingredient[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                colors[i2] = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            }
            colors = Arrays.stream(colors).filter(i -> !i.m_43947_()).toList().toArray(new Ingredient[0]);
            ItemStack result = pBuffer.m_130267_();
            return new ChiselTableRecipe(pRecipeId, group, material, template, colors, result);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, ChiselTableRecipe pRecipe) {
            int i;
            pBuffer.m_130070_(pRecipe.group);
            pRecipe.material.m_43923_(pBuffer);
            pRecipe.template.m_43923_(pBuffer);
            Ingredient[] colors = new Ingredient[4];
            for (i = 0; i < 4; ++i) {
                colors[i] = i < pRecipe.colors.size() ? pRecipe.colors.get(i) : Ingredient.f_43901_;
            }
            for (i = 0; i < 4; ++i) {
                colors[i].m_43923_(pBuffer);
            }
            pBuffer.m_130055_(pRecipe.result);
        }

        private static Ingredient parseIngredient(JsonObject json, String member) {
            JsonArray ingredientRaw = GsonHelper.m_13885_((JsonObject)json, (String)member) ? GsonHelper.m_13933_((JsonObject)json, (String)member) : GsonHelper.m_13930_((JsonObject)json, (String)member);
            return Ingredient.m_43917_((JsonElement)ingredientRaw);
        }
    }
}

